/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.LegacyFormattingParser;
import eu.pb4.placeholders.api.parsers.MarkdownLiteParserV1;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.StaticPreParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import eu.pb4.placeholders.api.parsers.TagLikeWrapper;
import eu.pb4.placeholders.api.parsers.TagParser;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.impl.textparser.MultiTagLikeParser;
import eu.pb4.placeholders.impl.textparser.SingleTagLikeParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class ParserBuilder {
    private final Map<TagLikeParser.Format, TagLikeParser.Provider> tagLike = new LinkedHashMap<TagLikeParser.Format, TagLikeParser.Provider>();
    private final List<NodeParser> parserList = new ArrayList<NodeParser>();
    private final List<class_124> legacyFormatting = new ArrayList<class_124>();
    private boolean hasLegacy = false;
    private boolean legacyRGB = false;
    private boolean simplifiedTextFormat;
    private boolean quickText;
    private boolean safeOnly;
    private TagRegistry customTagRegistry;
    private boolean staticPreParsing;

    public static ParserBuilder of() {
        return new ParserBuilder();
    }

    public ParserBuilder globalPlaceholders() {
        return this.add(Placeholders.DEFAULT_PLACEHOLDER_PARSER);
    }

    public ParserBuilder globalPlaceholders(TagLikeParser.Format format) {
        return this.customTags(format, TagLikeParser.Provider.placeholder(PlaceholderContext.KEY, Placeholders.DEFAULT_PLACEHOLDER_GETTER));
    }

    public ParserBuilder globalPlaceholders(TagLikeParser.Format format, ParserContext.Key<PlaceholderContext> contextKey) {
        return this.customTags(format, TagLikeParser.Provider.placeholder(contextKey, Placeholders.DEFAULT_PLACEHOLDER_GETTER));
    }

    public ParserBuilder placeholders(TagLikeParser.Format format, ParserContext.Key<PlaceholderContext> contextKey, Placeholders.PlaceholderGetter getter) {
        return this.customTags(format, TagLikeParser.Provider.placeholder(contextKey, getter));
    }

    public ParserBuilder placeholders(TagLikeParser.Format format, Function<String, TextNode> function) {
        return this.customTags(format, TagLikeParser.Provider.placeholder(function));
    }

    public ParserBuilder placeholders(TagLikeParser.Format format, ParserContext.Key<Function<String, class_2561>> key) {
        return this.customTags(format, TagLikeParser.Provider.placeholder(key));
    }

    public ParserBuilder placeholders(TagLikeParser.Format format, Set<String> tags, ParserContext.Key<Function<String, class_2561>> key) {
        return this.customTags(format, TagLikeParser.Provider.placeholder(tags, key));
    }

    public ParserBuilder quickText() {
        this.quickText = true;
        return this;
    }

    public ParserBuilder simplifiedTextFormat() {
        this.simplifiedTextFormat = true;
        return this;
    }

    public ParserBuilder requireSafe() {
        this.safeOnly = true;
        return this;
    }

    public ParserBuilder customTagRegistry(TagRegistry registry) {
        this.customTagRegistry = registry;
        return this;
    }

    public ParserBuilder markdown() {
        return this.add(MarkdownLiteParserV1.ALL);
    }

    public ParserBuilder markdown(MarkdownLiteParserV1.MarkdownFormat ... formats) {
        return this.add(new MarkdownLiteParserV1(formats));
    }

    public ParserBuilder markdown(Collection<MarkdownLiteParserV1.MarkdownFormat> formats) {
        return this.add(new MarkdownLiteParserV1(formats.toArray(new MarkdownLiteParserV1.MarkdownFormat[0])));
    }

    public ParserBuilder markdown(Function<TextNode[], TextNode> spoilerFormatting, Function<TextNode[], TextNode> quoteFormatting, BiFunction<TextNode[], TextNode, TextNode> urlFormatting, MarkdownLiteParserV1.MarkdownFormat ... formatting) {
        return this.add(new MarkdownLiteParserV1(spoilerFormatting, quoteFormatting, urlFormatting, formatting));
    }

    public ParserBuilder markdown(Function<TextNode[], TextNode> spoilerFormatting, Function<TextNode[], TextNode> quoteFormatting, BiFunction<TextNode[], TextNode, TextNode> urlFormatting, Collection<MarkdownLiteParserV1.MarkdownFormat> formatting) {
        return this.add(new MarkdownLiteParserV1(spoilerFormatting, quoteFormatting, urlFormatting, formatting.toArray(new MarkdownLiteParserV1.MarkdownFormat[0])));
    }

    public ParserBuilder legacyColor() {
        return this.add(LegacyFormattingParser.COLORS);
    }

    public ParserBuilder legacyVanillaColor() {
        return this.add(LegacyFormattingParser.BASE_COLORS);
    }

    public ParserBuilder legacyAll() {
        return this.add(LegacyFormattingParser.ALL);
    }

    public ParserBuilder legacy(boolean allowRGB, class_124 ... formatting) {
        this.hasLegacy = true;
        this.legacyRGB = allowRGB;
        this.legacyFormatting.addAll(List.of(formatting));
        return this;
    }

    public ParserBuilder legacy(boolean allowRGB, Collection<class_124> formatting) {
        this.hasLegacy = true;
        this.legacyRGB = allowRGB;
        this.legacyFormatting.addAll(formatting);
        return this;
    }

    public ParserBuilder customTags(TagLikeParser.Format format, TagLikeParser.Provider provider) {
        this.tagLike.put(format, provider);
        return this;
    }

    public ParserBuilder staticPreParsing() {
        this.staticPreParsing = true;
        return this;
    }

    public ParserBuilder add(NodeParser parser) {
        if (parser instanceof TagLikeWrapper) {
            TagLikeWrapper wrapper = (TagLikeWrapper)((Object)parser);
            TagLikeParser x = wrapper.asTagLikeParser();
            if (x instanceof SingleTagLikeParser) {
                SingleTagLikeParser p = (SingleTagLikeParser)x;
                return this.customTags(p.format(), p.provider());
            }
            if (x instanceof MultiTagLikeParser) {
                MultiTagLikeParser p = (MultiTagLikeParser)x;
                this.tagLike.putAll(Map.ofEntries(p.pairs()));
                return this;
            }
        } else if (parser instanceof LegacyFormattingParser) {
            LegacyFormattingParser legacyFormattingParser = (LegacyFormattingParser)parser;
            this.hasLegacy = true;
            this.legacyFormatting.addAll(legacyFormattingParser.formatting());
            this.legacyRGB |= legacyFormattingParser.allowRGB();
        }
        return this.forceAdd(parser);
    }

    public ParserBuilder forceAdd(NodeParser parser) {
        this.parserList.add(parser);
        return this;
    }

    public NodeParser build() {
        TagRegistry reg;
        ArrayList<NodeParser> list = new ArrayList<NodeParser>(this.parserList.size() + 1);
        if (!this.tagLike.isEmpty()) {
            list.add(TagLikeParser.of(this.tagLike));
        }
        TagRegistry tagRegistry = this.customTagRegistry != null ? this.customTagRegistry : (reg = this.safeOnly ? TagRegistry.SAFE : TagRegistry.DEFAULT);
        if (this.quickText && this.simplifiedTextFormat) {
            list.add(TagParser.createQuickTextWithSTF(reg));
        } else if (this.quickText) {
            list.add(TagParser.createQuickText(reg));
        } else if (this.simplifiedTextFormat) {
            list.add(TagParser.createSimplifiedTextFormat(reg));
        }
        list.addAll(this.parserList);
        if (this.hasLegacy) {
            list.add(new LegacyFormattingParser(this.legacyRGB, this.legacyFormatting.toArray(new class_124[0])));
        }
        if (this.staticPreParsing) {
            list.add(StaticPreParser.INSTANCE);
        }
        return NodeParser.merge(list);
    }
}

